/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.connectivity;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardCommitStatus;
import com.ibm.hsc.iw.WizardFrame;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.WizardTaskInterface;
import com.ibm.hsc.iw.WizardTaskPanel;
import com.ibm.hsc.iw.WizardTaskState;
import com.ibm.hsc.iw.tasks.connectivity.ChangeModemConfig;
import com.ibm.hsc.iw.tasks.connectivity.ConnectivityConstants;
import com.ibm.hsc.iw.tasks.connectivity.ConnectivityInit;
import com.ibm.hsc.iw.tasks.connectivity.ConnectivityState;
import com.ibm.hsc.iw.tasks.connectivity.PhoneNumberRequest;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableCountry;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableSubdivision;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigData;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigManager;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ConnectivityTask
implements WizardTaskInterface,
ConnectivityConstants {
    private static final String TRACE_MASKD = "JIWZCOTD";
    private static final String TRACE_MASKF = "JIWZCOTF";
    private static final String TRACE_MASKT = "JIWZCOTT";
    private OutboundConfigData outConfigData;
    private ModemConfigData modemConfigData;
    private ConnectivityInit connectivityInit;
    List availCountries = null;
    Map availSubdivisions = null;
    private String lastCountryCode = "";
    private String lastSubdivCode = "";

    public ConnectivityTask() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->ConnectivityTask()");
        }
    }

    public static void main(String[] stringArray) {
        if (Trace.LEVEL >= 3) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(' ');
                stringBuffer.append(stringArray[i]);
            }
            Trace.trace(TRACE_MASKD, "main() called with the following parameters :" + stringBuffer.toString());
        }
    }

    public LocalizableText getDescription() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getDescription()");
        }
        return new LocalizableText("com.ibm.hsc.common.bundles.ConnectivityText", "TASK_DESCRIPTION");
    }

    public WizardTaskState init(WizardFrame wizardFrame) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->init(" + wizardFrame + ")");
        }
        OutboundConfigManager outboundConfigManager = OutboundConfigManager.getOutboundConfigManager();
        this.outConfigData = outboundConfigManager.getOutboundConfig();
        Locale locale = UserContext.getCurrentUserContext().getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "locale from UserContext is null, using JVM default");
            }
        }
        ConnectionInfoManager connectionInfoManager = ConnectionInfoManager.getConnectionInfoManager();
        this.availCountries = connectionInfoManager.getDisplayableCountries(locale);
        this.availSubdivisions = connectionInfoManager.getDisplayableSubdivisions(locale);
        String string = this.getInitCountryCode();
        String string2 = this.getInitSubdivisionCode(string);
        List list = connectionInfoManager.getPhoneInfo("ATT", string, string2);
        ModemConfigManager modemConfigManager = ModemConfigManager.getModemConfigManager();
        this.modemConfigData = modemConfigManager.getModemConfig();
        LocalizableText localizableText = null;
        localizableText = new LocalizableText("com.ibm.hsc.remotesupport.service.res.LicenseAgreement", "TEXT");
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "The license agreement: \n" + localizableText);
        }
        this.connectivityInit = new ConnectivityInit(new ConnectivityState(this.outConfigData, new ChangeModemConfig(this.modemConfigData), localizableText), this.outConfigData, this.availCountries, string, this.availSubdivisions, string2, list);
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, outboundConfigManager.getOutboundConfig().toString());
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--init()");
        }
        return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.connectivity.res.Connectivity", "ConnectivityMainPanel", "com.ibm.hsc.iw.tasks.connectivity.ConnectivityMainBean", new LocalizableText("com.ibm.hsc.common.bundles.ConnectivityText", "TITLE_BAR_EXT_MAIN")), this.connectivityInit);
    }

    public void exit() {
    }

    public void handlePostedData(Serializable serializable) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->handlePostedData(" + serializable + ")");
        }
    }

    public Serializable handleData(Serializable serializable) {
        Object var2_2 = null;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->handleData(" + serializable + ")");
        }
        PhoneNumberRequest phoneNumberRequest = (PhoneNumberRequest)serializable;
        ConnectionInfoManager connectionInfoManager = ConnectionInfoManager.getConnectionInfoManager();
        List list = connectionInfoManager.getPhoneInfo("ATT", phoneNumberRequest.getCountryCode(), phoneNumberRequest.getSubdivCode());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--handleData(...) returning list of predefined numbers.");
        }
        return (Serializable)((Object)list);
    }

    public final boolean isVisible() {
        return true;
    }

    public WizardTaskState nextButtonHit(Serializable serializable) throws WizardTaskException {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->nextButtonHit()");
        }
        ConnectivityState connectivityState = (ConnectivityState)serializable;
        this.connectivityInit.setConnectivityState(connectivityState);
        if (connectivityState.getActivePanelName().equals("ConnectivityMainPanel")) {
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "nextButtonHit() - Connectivity Main Panel");
            }
            this.setMainInfo();
            if (connectivityState.getDialUpPanelChecked()) {
                connectivityState.pushActivePanelName("ConfigureDialUpPanel");
                return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.connectivity.res.Connectivity", "ConfigureDialUpPanel", "com.ibm.hsc.iw.tasks.connectivity.ConfigureDialUpBean", new LocalizableText("com.ibm.hsc.common.bundles.ConnectivityText", "TITLE_BAR_EXT_DIAL")), this.connectivityInit);
            }
            if (connectivityState.getVPNPanelChecked()) {
                connectivityState.pushActivePanelName("UseVPNPanel");
                return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.connectivity.res.Connectivity", "UseVPNPanel", "com.ibm.hsc.iw.tasks.connectivity.ConfigureVPNBean", new LocalizableText("com.ibm.hsc.common.bundles.ConnectivityText", "TITLE_BAR_EXT_VPN")), this.connectivityInit);
            }
            if (connectivityState.getPassThruPanelChecked()) {
                connectivityState.pushActivePanelName("ConfigurePassThruPanel");
                return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.connectivity.res.Connectivity", "ConfigurePassThruPanel", "com.ibm.hsc.iw.tasks.connectivity.ConfigurePassThruBean", new LocalizableText("com.ibm.hsc.common.bundles.ConnectivityText", "TITLE_BAR_EXT_PT")), this.connectivityInit);
            }
            connectivityState.pushActivePanelName("");
            return new WizardTaskState(null, this.connectivityInit);
        }
        if (connectivityState.getActivePanelName().equals("ConfigureDialUpPanel")) {
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "nextButtonHit() - Configure Dialup Panel");
            }
            this.setDialUpInfo();
            this.setModemConfigInfo();
            if (connectivityState.getVPNPanelChecked()) {
                connectivityState.pushActivePanelName("UseVPNPanel");
                return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.connectivity.res.Connectivity", "UseVPNPanel", "com.ibm.hsc.iw.tasks.connectivity.ConfigureVPNBean", new LocalizableText("com.ibm.hsc.common.bundles.ConnectivityText", "TITLE_BAR_EXT_VPN")), this.connectivityInit);
            }
            if (connectivityState.getPassThruPanelChecked()) {
                connectivityState.pushActivePanelName("ConfigurePassThruPanel");
                return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.connectivity.res.Connectivity", "ConfigurePassThruPanel", "com.ibm.hsc.iw.tasks.connectivity.ConfigurePassThruBean", new LocalizableText("com.ibm.hsc.common.bundles.ConnectivityText", "TITLE_BAR_EXT_PT")), this.connectivityInit);
            }
            connectivityState.pushActivePanelName("");
            return new WizardTaskState(null, this.connectivityInit);
        }
        if (connectivityState.getActivePanelName().equals("UseVPNPanel")) {
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "nextButtonHit() - Use VPN Panel");
            }
            if (connectivityState.getPassThruPanelChecked()) {
                connectivityState.pushActivePanelName("ConfigurePassThruPanel");
                return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.connectivity.res.Connectivity", "ConfigurePassThruPanel", "com.ibm.hsc.iw.tasks.connectivity.ConfigurePassThruBean", new LocalizableText("com.ibm.hsc.common.bundles.ConnectivityText", "TITLE_BAR_EXT_PT")), this.connectivityInit);
            }
            connectivityState.pushActivePanelName("");
            return new WizardTaskState(null, this.connectivityInit);
        }
        if (Trace.LEVEL >= 3) {
            Trace.trace(TRACE_MASKD, "nextButtonHit() - Panel 3");
        }
        this.setPassThruInfo();
        connectivityState.pushActivePanelName("");
        return new WizardTaskState(null, this.connectivityInit);
    }

    public Object backButtonHit(Serializable serializable) {
        ConnectivityState connectivityState = (ConnectivityState)serializable;
        this.connectivityInit.setConnectivityState(connectivityState);
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->backButtonHit()");
        }
        return this.connectivityInit;
    }

    public Object backedIntoPanel(WizardTaskState wizardTaskState) {
        String string;
        ConnectivityState connectivityState = this.connectivityInit.getConnectivityState();
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->backedIntoPanel()");
        }
        if ((string = connectivityState.popActivePanelName()).equals("ConfigureDialUpPanel")) {
            this.setDialUpInfo();
            this.setModemConfigInfo();
        } else if (!string.equals("UseVPNPanel")) {
            if (string.equals("ConfigurePassThruPanel")) {
                this.setPassThruInfo();
            } else if (string.equals("ConnectivityMainPanel")) {
                this.setMainInfo();
            } else if (!string.equals("")) {
                new AusMicrocodeLog(LOG_INFO_TASK, 2).writeEntry(null);
                if (Trace.LEVEL >= 2) {
                    Trace.trace(TRACE_MASKF, "   backedIntoPanel() - no panel match");
                }
            }
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--backedIntoPanel()");
        }
        return this.connectivityInit;
    }

    public LocalizableText[] prepareToCommit(Object object) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->prepareToCommit()");
        }
        ConnectivityInit connectivityInit = (ConnectivityInit)object;
        ConnectivityState connectivityState = connectivityInit.getConnectivityState();
        LocalizableText[] localizableTextArray = null;
        localizableTextArray = connectivityState.hasModemConfigChanged() ? new LocalizableText[2] : new LocalizableText[]{new LocalizableText("com.ibm.hsc.common.bundles.ConnectivityText", "COMMIT_DESCRIPTION")};
        if (connectivityState.hasModemConfigChanged()) {
            localizableTextArray[1] = new LocalizableText("com.ibm.hsc.common.bundles.ConnectivityText", "COMMIT_MODEM_DESCRIPTION");
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--prepareToCommit()");
        }
        return localizableTextArray;
    }

    public WizardCommitStatus commit(Object object) {
        ConnectivityInit connectivityInit = (ConnectivityInit)object;
        ConnectivityState connectivityState = connectivityInit.getConnectivityState();
        boolean bl = true;
        boolean bl2 = true;
        HSCLocalizableMsg[] hSCLocalizableMsgArray = null;
        Object[] objectArray = null;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->commit()");
        }
        hSCLocalizableMsgArray = connectivityState.hasModemConfigChanged() ? new HSCLocalizableMsg[2] : new HSCLocalizableMsg[1];
        bl2 = this.setConnectivityInfo();
        if (bl2) {
            hSCLocalizableMsgArray[0] = new HSCLocalizableMsg(MsgType.INFORMATION_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0600", objectArray);
        } else {
            bl = false;
            hSCLocalizableMsgArray[0] = new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0601", objectArray);
        }
        if (connectivityState.hasModemConfigChanged()) {
            bl2 = this.setModemConfigData();
            if (bl2) {
                hSCLocalizableMsgArray[1] = new HSCLocalizableMsg(MsgType.INFORMATION_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0603", objectArray);
            } else {
                bl = false;
                hSCLocalizableMsgArray[1] = new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0604", objectArray);
            }
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--commit()");
        }
        return new WizardCommitStatus(bl, hSCLocalizableMsgArray);
    }

    public boolean isCallHomeServer() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->isCallHomeServer()");
        }
        return this.outConfigData.isAllowDial() || this.outConfigData.isAllowInternet() || this.outConfigData.isAllowPassthru();
    }

    private void setMainInfo() {
        ConnectivityState connectivityState;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->setMainInfo()");
        }
        if ((connectivityState = this.connectivityInit.getConnectivityState()).getDialUpPanelChecked()) {
            this.outConfigData.setAllowDial(true);
        } else {
            this.outConfigData.setAllowDial(false);
        }
        if (connectivityState.getVPNPanelChecked()) {
            this.outConfigData.setAllowInternet(true);
        } else {
            this.outConfigData.setAllowInternet(false);
        }
        if (connectivityState.getPassThruPanelChecked()) {
            this.outConfigData.setAllowPassthru(true);
        } else {
            this.outConfigData.setAllowPassthru(false);
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--setMainInfo()");
        }
    }

    private void setDialUpInfo() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->setDialUpInfo()");
        }
        ConnectivityState connectivityState = this.connectivityInit.getConnectivityState();
        this.outConfigData.setPhoneInfo(connectivityState.getDialUpInfo());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--setDialUpInfo()");
        }
    }

    private void setModemConfigInfo() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->setModemConfigInfo()");
        }
        ConnectivityState connectivityState = this.connectivityInit.getConnectivityState();
        ChangeModemConfig changeModemConfig = connectivityState.getModemConfigData();
        this.modemConfigData.setDialType(changeModemConfig.getDialType());
        this.modemConfigData.setWaitForDialTone(changeModemConfig.isWaitForDialTone());
        this.modemConfigData.setEnableSpeaker(changeModemConfig.isEnableSpeaker());
        this.modemConfigData.setDialPrefix(changeModemConfig.getDialPrefix());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--setModemConfigInfo()");
        }
    }

    private void setPassThruInfo() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->setPassThruInfo()");
        }
        ConnectivityState connectivityState = this.connectivityInit.getConnectivityState();
        this.outConfigData.setPassthruInfo(connectivityState.getPassThruInfo());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--setPassThruInfo()");
        }
    }

    private boolean setConnectivityInfo() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->setConnectivityInfo()");
        }
        ConnectivityState connectivityState = this.connectivityInit.getConnectivityState();
        this.outConfigData.setCallHomeServer(this.isCallHomeServer());
        OutboundConfigManager outboundConfigManager = OutboundConfigManager.getOutboundConfigManager();
        try {
            outboundConfigManager.setOutboundConfig(this.outConfigData);
        }
        catch (Exception exception) {
            if (Trace.LEVEL >= 1) {
                Trace.trace(TRACE_MASKT, "<--setConnectivityInfo() returning FALSE. Exception caught:" + exception);
            }
            exception.printStackTrace();
            return false;
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--setConnectivityInfo() returning TRUE.");
        }
        return true;
    }

    private boolean setModemConfigData() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->setModemConfigData()");
        }
        ConnectivityState connectivityState = this.connectivityInit.getConnectivityState();
        ModemConfigManager modemConfigManager = ModemConfigManager.getModemConfigManager();
        try {
            modemConfigManager.setModemConfig(this.modemConfigData);
        }
        catch (Exception exception) {
            if (Trace.LEVEL >= 1) {
                Trace.trace(TRACE_MASKT, "<--setModemConfigData() returning FALSE. Exception caught:" + exception);
            }
            exception.printStackTrace();
            return false;
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--setModemConfigData() returning TRUE.");
        }
        return true;
    }

    private String getInitCountryCode() {
        Locale locale;
        Object object;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->getInitCountryCode()");
        }
        String string = "";
        if (!this.lastCountryCode.equals("")) {
            string = this.lastCountryCode;
        } else {
            CustomerInfoManager customerInfoManager = CustomerInfoManager.getCustomerInfoManager();
            object = customerInfoManager.getCustomerInfo();
            string = object.getSystemCountryCode();
            if (string.equals("")) {
                locale = UserContext.getCurrentUserContext().getLocale();
                if (locale == null) {
                    locale = Locale.getDefault();
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "locale from UserContext is null, using JVM default");
                    }
                }
                string = locale.getCountry();
            }
        }
        boolean bl = false;
        object = this.availCountries.iterator();
        while (object.hasNext()) {
            locale = (DisplayableCountry)object.next();
            if (!locale.getIsoCode().equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            string = "";
        }
        this.lastCountryCode = string;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--getInitCountryCode() = " + string);
        }
        return string;
    }

    private String getInitSubdivisionCode(String string) {
        Object object;
        Object object2;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->getInitSubdivisionCode()");
        }
        String string2 = "";
        boolean bl = this.availSubdivisions.containsKey(string);
        if (!this.lastSubdivCode.equals("")) {
            string2 = this.lastSubdivCode;
        } else {
            CustomerInfoManager customerInfoManager = CustomerInfoManager.getCustomerInfoManager();
            object2 = customerInfoManager.getCustomerInfo();
            string2 = object2.getSystemSubdivisionCode();
            if (string2.equals("") && bl) {
                object = (List)this.availSubdivisions.get(string);
                string2 = ((DisplayableSubdivision)object.get(0)).getIsoCode();
            }
        }
        boolean bl2 = false;
        if (bl) {
            object2 = (List)this.availSubdivisions.get(string);
            object = object2.iterator();
            while (object.hasNext()) {
                DisplayableSubdivision displayableSubdivision = (DisplayableSubdivision)object.next();
                if (!displayableSubdivision.getIsoCode().equals(string2)) continue;
                bl2 = true;
                break;
            }
        }
        if (!bl2) {
            string2 = "";
        }
        this.lastSubdivCode = string2;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--getInitSubdivisionCode() = " + string2);
        }
        return string2;
    }

    public WizardTaskState reEnter(Object object) {
        return null;
    }
}

